function updateSecurityPageValue() {
    $("#securityEnableInput").prop("checked", (cameraSettings.Dot1XWiredFunc == "on") ? true : false);
    if (cameraSettings.Dot1XIdentity !== "00000000000000000000") {
        $("#eapIdentifyInput").val(cameraSettings.Dot1XIdentity);
    } else {
        $("#eapIdentifyInput").val("");
    }
    if (cameraSettings.Dot1XPasswordUsed == "1") {
        $("#eapPasswordInput").val("xxxxxxxxxx");
    } else {
        $("#eapPasswordInput").val("");
    }
    $("#importFileNameInput").val(cameraSettings.CACertFileName);
    $("#issuerDNInput").val(cameraSettings.CACertIssuerDn);
    $("#subjectDNInput").val(cameraSettings.CACertSubjectDn);
    $("#availableFromInput").val(cameraSettings.CACertValidityFrom);
    $("#availableToInput").val(cameraSettings.CACertValidityTo);
}

function updateSecurityEnable() {
    if (document.getElementById("securityEnableInput").checked == true) {
        document.getElementById("eapIdentifyInput").disabled = false;
        document.getElementById("eapPasswordInput").disabled = false;
        document.getElementById("chooseFileButton").disabled = false;
    } else {
        document.getElementById("eapIdentifyInput").disabled = true;
        document.getElementById("eapPasswordInput").disabled = true;
        document.getElementById("chooseFileButton").disabled = true;
        $("#eapIdentifyInput").val("");
        $("#eapPasswordInput").val("");
        $("#importFileNameInput").val("");
        $("#issuerDNInput").val("");
        $("#subjectDNInput").val("");
        $("#availableFromInput").val("");
        $("#availableToInput").val("");
    }
}

var uploadfile = {};

function uploadAction8021x(files) {
    document.getElementById("importFileNameInput").value = "";
    if (typeof files !== 'undefined') {
        uploadfile = files[0];
        if ((uploadfile !== null) && (uploadfile.name !== null) && (uploadfile.size <= 2048000)) {
            document.getElementById("importFileNameInput").value = uploadfile.name.toString();
            var formdata = new FormData();
            formdata.append('fileupload8021x', uploadfile);

            $.ajax({
                url: "/command/dot1x.cgi",
                type: "POST",
                contentType: false,
                processData: false,
                data: formdata,
                error: function (xhr) {},
                timeout: 0,
                error: function (xhr) {
                    console.log("lums_802dot1xcacert1 - error01");
                    document.getElementById("issuerDNInput").value = "";
                    document.getElementById("subjectDNInput").value = "";
                    document.getElementById("availableFromInput").value = "";
                    document.getElementById("availableToInput").value = "";
                },
                success: function (response) {
                    var obj = JSON.parse(response);
                    if (obj.STATUS == "OK") {
                        if (document.getElementById("securityEnableInput").checked == true) {
                            document.getElementById("issuerDNInput").value = obj.Issuerbuf;
                            document.getElementById("subjectDNInput").value = obj.Subjectbuf;
                            document.getElementById("availableFromInput").value = obj.NotBeforebuf;
                            document.getElementById("availableToInput").value = obj.NotAfterbuf;
                        } else {
                            document.getElementById("issuerDNInput").value = "";
                            document.getElementById("subjectDNInput").value = "";
                            document.getElementById("availableFromInput").value = "";
                            document.getElementById("availableToInput").value = "";
                            document.getElementById("importFileNameInput").value = "";
                        }
                    } else {
                        console.log("CA certificate is not valid!");
                        document.getElementById("issuerDNInput").value = "";
                        document.getElementById("subjectDNInput").value = "";
                        document.getElementById("availableFromInput").value = "";
                        document.getElementById("availableToInput").value = "";
                    }
                }
            }).then(function (data) {
                ;
            });

        } else {
            console.log("CA certificate is not valid!");
            document.getElementById("issuerDNInput").value = "";
            document.getElementById("subjectDNInput").value = "";
            document.getElementById("availableFromInput").value = "";
            document.getElementById("availableToInput").value = "";
            document.getElementById("importFileNameInput").value = "";
        }
    }
}

function saveSecuritySettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/dot1x.cgi?";
    warningMessage = "";

    cgiParam.Dot1XWiredFunc = ($('#securityEnableInput').is(':checked') == true) ? "on" : "off";
    AddParameter("Dot1XWiredFunc", cgiParam.Dot1XWiredFunc);
    if (cgiParam.Dot1XWiredFunc == "on") {
        cgiParam.Dot1XIdentity = $("#eapIdentifyInput").val();
        AddParameter("Dot1XIdentity", cgiParam.Dot1XIdentity);
        if (cgiParam.Dot1XIdentity.length < 4 || cgiParam.Dot1XIdentity.length > 128) {
            warningMessage += "Name should have minimum of 4 characters and maximum of 128 characters.<br>";
        }
        if (cameraSettings.Dot1XPasswordUsed != 1) {
            cgiParam.Dot1XPassword = $("#eapPasswordInput").val();
            AddParameter("Dot1XPassword", cgiParam.Dot1XPassword);
            if (cgiParam.Dot1XPassword.length < 4 || cgiParam.Dot1XPassword.length > 128) {
                warningMessage += "The Password must contain 4-128 characters.<br>";
            }
        }
        cgiParam.CACertFileName = $("#importFileNameInput").val();
        AddParameter("CACertFileName", cgiParam.CACertFileName);
        if (cgiParam.CACertFileName == "") {
            warningMessage += "CA certificate is not valid!<br>";
        }
    }

    if (warningMessage.length > 0) {
        showMessageModal("Warning", warningMessage, null);
        return;
    }

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send dot1x Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("dot1x settings saved to " + cameraSettings.CameraName);
            reloadSecurity();
            UnblockUIforPage();
        }
    });
}

function reloadSecurity() {
    openSecurity();
}

function openSecurity() {
    $("#DivMainPage").load("./page/security.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        $.ajax({
            url: "/command/inquiry.cgi?inqjs=system&inqjs=dot1x",
            type: "GET",
            error: function (xhr) {
                console.log("Get security info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                updateSecurityPageValue();
                if (cameraSettings.NtpService == "on") {
                    document.getElementById("securityEnableInput").disabled = false;
                    document.getElementById("applyButton").disabled = false;
                    document.getElementById("cancelButton").disabled = false;
                } else {
                    document.getElementById("securityEnableInput").disabled = true;
                    document.getElementById("eapIdentifyInput").disabled = true;
                    document.getElementById("eapPasswordInput").disabled = true;
                    document.getElementById("chooseFileButton").disabled = true;
                    document.getElementById("applyButton").disabled = true;
                    document.getElementById("cancelButton").disabled = true;
                }
                updateSecurityEnable();

                $("#securityEnableInput").change(function () {
                    updateSecurityEnable();
                });
                $('#eapPasswordInput').on('focusin', function () {
                    if (cameraSettings.Dot1XPasswordUsed == "1") {
                        cameraSettings.Dot1XPasswordUsed = "changed";
                        $(this).val('');
                    }
                });
                $("#chooseFileButton").on('click', function () {
                    $('#fileupload8021x').trigger('click');
                });
                $("#applyButton").on('click', saveSecuritySettings);
                $("#cancelButton").on('click', reloadSecurity);
            }
        });
    });
}
